unit MainForm;

interface

uses
  Windows, Messages, SysUtils, Variants, Classes, Graphics, Controls, Forms,
  Dialogs, Borland.Vcl.StdCtrls, Borland.Vcl.ComCtrls,
  System.ComponentModel, IdBaseComponent, IdComponent, IdTCPConnection,
  IdTCPClient, IdMessageClient, IdPOP3, IdMessage;

type
  TformMain = class(TForm)
    IdPOP31: TIdPOP3;
    ListView1: TListView;
    butnGetHeaders: TButton;
    IdMessage1: TIdMessage;
    procedure butnGetHeadersClick(Sender: TObject);
  private
    { Private declarations }
  public
    { Public declarations }
  end;

var
  formMain: TformMain;

implementation

uses ServerInfo, IdEMailAddress;

{$R *.nfm}

procedure TformMain.butnGetHeadersClick(Sender: TObject);
var
  i: Integer;
begin
  with formServerInfo do begin
    if ShowModal = mrOk then begin
      IdPOP31.Host := editServer.Text;
      IdPOP31.Username := editUsername.Text;
      IdPOP31.Password := editPassword.Text;
      try
        IdPOP31.Connect;
        for i := 1 to IdPOP31.CheckMessages do begin
          IdPOP31.RetrieveHeader(i, IdMessage1);
          with ListView1.Items.Add do begin
            Caption := IdMessage1.From.Text;
            SubItems.Add(IdMessage1.Recipients.EMailAddresses);
            SubItems.Add(IdMessage1.Subject);
            SubItems.Add(DateToStr(IdMessage1.Date));
          end;
        end;
      finally
        IdPOP31.Disconnect;
      end;
    end;
  end;
end;

end.
